/*
   Important: Notice that this program is logically
   the same as the following command line pipe.

   C:\> java RemoveVowels | java ToUpperCase

   In the case of the above command line, the shell
   program (cmd.exe) sets up the pipeline before running
   the two programs RemoveVowels.class and ToUpperCase.class.
   In the case of this program, the program itself creates
   the pipeline between the two child processes.  So this
   program is acting like a very simple shell program.
*/
import java.io.*;

public class Java7_Pipeline_v2
{
   public static void main(String[] args) throws IOException, InterruptedException
   {
      // Create a command line for the stage2 child.
      ProcessBuilder pb2 = new ProcessBuilder("java", "ToUpperCase");

      // Have stage2 inherit this parent's standard output streams.
      pb2.redirectOutput( ProcessBuilder.Redirect.INHERIT );

      // Execute the stage2 process.
      Process process2 = pb2.start();

      // Redirect the parent's System.out to be the standard input of the stage2 process.
      System.setOut( new PrintStream( process2.getOutputStream() ) );


      // This demonstrates that the output stream of this parent
      // process is now set to the input to the stage2 process.
      System.out.println("this is a test of touppercase");
      System.out.flush();


      // Create a command line for the stage1 child.
      ProcessBuilder pb1 = new ProcessBuilder("java", "RemoveVowels");
      // Have stage1 inherit this parent's standard input stream.
      pb1.redirectInput( ProcessBuilder.Redirect.INHERIT );
      // Now have stage1 inherit this parent's (NEW VERSION OF) stdout.
      pb1.redirectOutput( ProcessBuilder.Redirect.INHERIT );  // THIS DOESN'T WORK RIGHT??

      // Execute the stage1 process (start the pipeline).
      Process process1 = pb1.start();

      // Wait for the stage1 process to finish.
      process1.waitFor();
         System.out.println("this is another test of touppercase"); // This shouldn't be needed!
         System.out.close();
      // Wait for the stage2 process to finish its work.
      process2.waitFor();  // this throws InterruptedException
   }
}